# Bumblebee And NVidia Display applet (BAND)

## Summary

The Bumblebee And NVidia Display (Band) Applet is a relatively simple applet I wrote for my Chillblast Defiant laptop which has an Core i7 Haswell architecture and Optimus technology to switch between the integrated Intel 4600 graphics and discrete nVidia GTX 765M graphics. The switching is done by use of Bumblebee. This Applet allows one to monitor whether the power consuming discrete graphics is on and display the GPU temperature, but only when it is enabled. Monitoring the temperature requires the graphics processor to be turned on every time it is measured - some applets do this all the time and that uses a significant extra amount of power.

## Rationale

It is useful to have continuous indication of whether the Discrete Graphics Processor Unit is in use and its temperature which is a concern on some laptops.

The latest versions of Cinnamon provide more support to Bumblebee but the option of running programs from the applet is still important if you want to use primus instead of optirun or use additional parameters to optimise the transport mechanism used by VirtualGL to copy the image generated by the nVidia GPU to your display which can offer significant improvements in speed. I wrote about this at http://www.pcurtis.com/defiant.htm#bumblebee_options

## Status

I have recently reloaded Bumblebee using the instructions at http://www.webupd8.org/2016/08/how-to-install-and-configure-bumblebee.html under Mint 17.3 (32 bit) and 18.1 (64 bit) (I have a dual boot system) and it all seems to still work fine under both. The use of vertical panels has only been tested under Mint 18.1 with Cinnamon 3.2.
 
## Features

The latest versions 3.2.0 and higher work with horizontal and vertical panels.  The indication of which GPU is active has changed to be an icon. The GPU temperature display is beside the icon on horizontal panels and below on vertical panels.  The display is shortened (by removing the degree symbol) if over 100 degrees on vertical panels because of width restrictions.

The temperature display in the panel can now be inhibited to save space if required in settings.  One can also configure the update rate of the applet in settings.

The Right Click (Context menu) gives the ability to easily run the nVidia Settings program without use of the terminal and also the System Monitor and Power Statistics, all useful for monitoring Bumblebee and Power consumption which is paramount when using a laptop on batteries.

The standard Left Click menu provides a configurable list of programs which one can run using the discrete nVidia graphics through Bumblebee. This list is configured using the standard applet configuration mechanism.  Currently there are two examples - glxspheres64 is a very good test of the speed of the graphics but may need to be installed. The other example is the nVidia Settings program. There are 5 'slots' currently and if you do not require a slot set the Display Name to null or leave it completely empty.

There is error checking to ensure bumblebee is loaded and does not fill the error logs with messages when that is the case. It displays a message of Err if bumblebee is not loaded and a message when you hover. 

## Requirements

The applet requires at least Cinnamon 2.0. Mint versions with less than Cinnamon 2.2 have now passed their end of life so all current version including 3.4 are supported. Cinnamon 3.2 or higher is required to support a vertical panel but not to support other features of the applet.

The Bumblebee and the nVidia graphics packages obviously need to be installed but no other packages are essential.

glxsheres64 only needs to be installed if you want to use the applet to test the relative performances of the Intel and nVidia graphics processors. glxsheres64 is part of the VirtualGL package which needs to be installed from  http://sourceforge.net/projects/virtualgl/files/VirtualGL/ - download the latest version and install using gdebi. It should run about five times faster when the nVidia GPU is active and is a very good test as to how good your cooling is for both the CPU and nVidia GPU when it is active.

## Translations and other Contributions

The internal changes required in the applet to allow translations have been implemented and Chinese and Croatian translations are already available. Translations are contributed by people fluent in the language and are very much appreciated but users please note I am unable to take responsibility for the accuracy of translations!

Although comments and suggestions are always welcome any contributions which are contemplated should follow discussion. 

## Manual Installation:

   * Make sure Bumblebee is installed and working.
   * Download from the Spices Web Site
   * Unzip and extract folder ```bumblebee@pdcurtis``` to ```~/.local/share/cinnamon/applets/```
   * Install glxspheres64 if required.
   * Enable the applet in System Settings -> Applets
   * You can also access the Settings Screen from System Settings -> Applets or from the Applets Context menu
