#!/usr/bin/gjs

imports.gi.versions.Gtk = "3.0";
const Gtk = imports.gi.Gtk;
const GLib = imports.gi.GLib;

function onKeyPress(actor, event) {
    const [, key] = event.get_keyval();
    const [, modifier] = event.get_state();

    if ((key === 65307 /* ESC */) || (key === 119 /* w */ && modifier == 20 /* ctrl */)) {
        actor.close();
        Gtk.main_quit();
    }
}

Gtk.init(null);

let win = new Gtk.Window({ title: ARGV[0] });
win.set_position(Gtk.WindowPosition.CENTER);

let vbox = new Gtk.VBox({ spacing: 12 });
vbox.set_border_width(10);

let scroll = new Gtk.ScrolledWindow();
scroll.set_policy(Gtk.PolicyType.AUTOMATIC, Gtk.PolicyType.AUTOMATIC);

let textview = new Gtk.TextView();
textview.set_editable(false);
let textContent = new TextDecoder().decode(GLib.file_get_contents(ARGV[1])[1]).trim();
textview.buffer.text = textContent;

let lineCount = textContent.split("\n").length;
let height = Math.min(640, Math.max(100, lineCount * 10));
scroll.set_size_request(640, height);

scroll.add(textview);
vbox.pack_start(scroll, true, true, 0);

let okButton = new Gtk.Button({ label: "OK" });
okButton.connect("clicked", () => Gtk.main_quit());
vbox.pack_start(okButton, false, false, 0);

win.add(vbox);

win.connect("delete-event", () => Gtk.main_quit());
win.connect("key-press-event", onKeyPress);

win.show_all();
Gtk.main();
