/* This file was generated by webpack. Do not edit directly. */

/*!
 * This file is part of the fish@kriegcc applet project for Cinnamon desktop.
 * 
 * Copyright (C) 2025 kriegcc
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

var fishApplet;
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  main: () => (/* binding */ main)
});

;// ./src/consts/common.ts
const UUID = "fish@kriegcc";
const KNOWN_USEFUL_PROGRAMS = ["ps", "who", "uptime", "tail"];
const FISH_APPLET_CINNAMON_SPICES_WEBSITE = "https://cinnamon-spices.linuxmint.com/applets/view/401";
const REPORT_BUGS_INSTRUCTIONS_WEBSITE = "https://github.com/linuxmint/cinnamon-spices-applets/blob/master/.github/CONTRIBUTING.md";

;// ./src/utils/logging/Logger.ts

const { isError } = imports.ui.main;
function mapStringToLogLevel(logLevel) {
    if (logLevel === "Info" || logLevel === "Debug" || logLevel === "Warning" || logLevel === "Error") {
        return logLevel;
    }
    throw new Error(`Invalid log level value: ${logLevel}`);
}
const DEFAULT_LOG_LEVEL = "Info";
const logLevelPriority = {
    Error: 1,
    Warning: 2,
    Info: 3,
    Debug: 4,
};
class Logger {
    constructor(instanceId, logLevel = DEFAULT_LOG_LEVEL) {
        this.instanceId = instanceId;
        this.logLevel = logLevel;
    }
    setInstanceId(instanceId) {
        this.instanceId = instanceId;
    }
    setLogLevel(logLevel) {
        this.logLevel = logLevel;
    }
    logInfo(...msg) {
        if (this.canLog("Info")) {
            global.log(this.formatMessage("Info", ...msg));
        }
    }
    logDebug(...msg) {
        if (this.canLog("Debug")) {
            global.log(this.formatMessage("Debug", ...msg));
        }
    }
    logWarning(...msg) {
        if (this.canLog("Warning")) {
            global.logWarning(this.formatMessage("Warning", ...msg));
        }
    }
    logError(msg, error) {
        if (this.canLog("Error")) {
            global.logError(this.formatMessage("Error", msg));
            if (this.isCjsOrGlibError(error)) {
                global.logError(error);
            }
        }
    }
    formatMessage(logLevel, ...msg) {
        const formattedMessage = msg.join(" ");
        return `[${UUID}#${this.instanceId}:${logLevel}]: ${formattedMessage}`;
    }
    canLog(logLevel) {
        return logLevelPriority[logLevel] <= logLevelPriority[this.logLevel];
    }
    isCjsOrGlibError(error) {
        return isError(error);
    }
}
const logger = new Logger();

;// ./src/utils/logging/index.ts


;// ./src/utils/common/common.ts

const { St } = imports.gi;
const { GLib } = imports.gi;
function isHorizontalOriented(orientation) {
    return orientation === St.Side.TOP || orientation === St.Side.BOTTOM;
}
function isVerticalOriented(orientation) {
    return orientation === St.Side.LEFT || orientation === St.Side.RIGHT;
}
const expandHomeDir = (path) => {
    if (path.startsWith("~")) {
        const homeDir = GLib.get_home_dir();
        return path.replace("~", homeDir);
    }
    return path;
};
const MAX_PAUSE_IN_MS = 10000;
const MIN_PAUSE_IN_MS = 100;
function isAnimationSpeedValid(speed) {
    if (speed < 0) {
        logger.logError(`Animation speed value must not be negative. Speed: ${speed}`);
        return false;
    }
    if (speed < MIN_PAUSE_IN_MS) {
        logger.logError(`Animation speed value must not be lower than ${MIN_PAUSE_IN_MS}. Speed: ${speed}`);
        return false;
    }
    if (speed > MAX_PAUSE_IN_MS) {
        logger.logError(`Animation speed value must not be higher than ${MAX_PAUSE_IN_MS}. Speed: ${speed}`);
        return false;
    }
    return true;
}

;// ./src/utils/common/command.ts
const { spawnCommandLineAsyncIO, spawnCommandLine } = imports.misc.util;
function runCommandAsyncIO(command, callback, errorCallback) {
    spawnCommandLineAsyncIO(command, (stdout, stderr, exitCode) => {
        if (exitCode !== 0) {
            errorCallback(new Error(`Failed to run command ${command}. ${stderr}`));
            return;
        }
        callback(stdout);
    });
}
function runCommand(command) {
    spawnCommandLine(command);
}
function openWebsite(url) {
    runCommand("xdg-open " + url);
}

;// ./src/utils/common/foolsDay.ts

const { spawnCommandLineAsyncIO: foolsDay_spawnCommandLineAsyncIO } = imports.misc.util;
async function isFoolsDay() {
    const spanishTimezones = [
        "Europe/Madrid",
        "Africa/Ceuta",
        "Atlantic/Canary",
        "America/Mexico_City",
        "Mexico/BajaSur",
        "Mexico/BajaNorte",
        "Mexico/General",
    ];
    const now = new Date();
    const month = now.getMonth();
    const date = now.getDate();
    const hour = now.getHours();
    const location = await getLocation();
    let foolsDay = 1;
    let foolsMonth = 3;
    const foolsHourStart = 0;
    const foolsHourEnd = 12;
    if (location && spanishTimezones.includes(location)) {
        foolsDay = 28;
        foolsMonth = 11;
    }
    if (month === foolsMonth && date === foolsDay && hour >= foolsHourStart && hour < foolsHourEnd) {
        return true;
    }
    return false;
}
async function getLocation() {
    try {
        const timezone = await readFile("/etc/timezone");
        if (timezone) {
            return timezone.trim();
        }
        const localtimePath = await readSymlink("/etc/localtime");
        if (localtimePath) {
            const parts = localtimePath.split("/");
            if (parts.length >= 3) {
                return parts.slice(-2).join("/");
            }
        }
        return null;
    }
    catch (error) {
        logger.logError("Error getting location:", error);
        return null;
    }
}
function readSymlink(filePath) {
    return new Promise((resolve, _) => {
        foolsDay_spawnCommandLineAsyncIO(`readlink ${filePath}`, (output) => {
            if (output) {
                resolve(output.trim());
            }
            else {
                resolve(null);
            }
        });
    });
}
function readFile(filePath) {
    return new Promise((resolve, _) => {
        foolsDay_spawnCommandLineAsyncIO(`cat ${filePath}`, (output) => {
            if (output) {
                resolve(output);
            }
            else {
                resolve(null);
            }
        });
    });
}

;// ./src/utils/common/theme.ts
function getThemeAppearance(className) {
    const theme = getThemeNodeOfClass(className);
    const color = theme.get_foreground_color();
    const invertedColor = invertColor(color);
    return inferThemeAppearanceFromColor(invertedColor);
}
function inferThemeAppearanceFromColor(color) {
    const red = color.red / 255;
    const green = color.green / 255;
    const blue = color.blue / 255;
    const luminance = 0.2126 * red + 0.7152 * green + 0.0722 * blue;
    const isDarkTheme = luminance < 0.5;
    return isDarkTheme ? "Dark" : "Light";
}
function getThemeNodeOfClass(className) {
    const themeContext = imports.gi.St.ThemeContext.get_for_stage(global.stage);
    const themeNode = imports.gi.St.ThemeNode.new(themeContext, null, themeContext.get_theme(), imports.gi.St.Widget, "", className, "", " ", true);
    return themeNode;
}
function getThemeNodeOfWidget(widget) {
    if (!isWidgetOnStage(widget)) {
        throw new Error("Actor is not on the stage.");
    }
    return widget.get_theme_node();
}
function isWidgetOnStage(widget) {
    return !!widget.get_parent();
}
function invertColor(color) {
    const invertedColor = new imports.gi.Clutter.Color({
        red: 255 - color.red,
        green: 255 - color.green,
        blue: 255 - color.blue,
        alpha: color.alpha,
    });
    return invertedColor;
}
function getMargin(className) {
    const themeNode = getThemeNodeOfClass(className);
    const margin = themeNode.get_horizontal_padding() +
        themeNode.get_border_width(imports.gi.St.Side.TOP) +
        themeNode.get_border_width(imports.gi.St.Side.BOTTOM);
    return margin;
}

;// ./src/utils/common/renderOptions.ts
function mapStringToAnimationScalingMode(mode) {
    if (mode === "AutoFit" || mode === "PreserveOriginal" || mode === "Custom") {
        return mode;
    }
    throw new Error(`Invalid animation scaling mode value: ${mode}`);
}
function mapNumberToAnimationRotation(rotation) {
    if (rotation === 0 || rotation === 90 || rotation === 180 || rotation === 270) {
        return rotation;
    }
    throw new Error(`Invalid rotation value: ${rotation}`);
}
function determineRenderOptionsFromSettings(props) {
    const { isInHorizontalPanel, panelHeight, scalingMode, margin, customHeight, customWidth, isPreserveAspectRatio, isFlipSidewaysOnVerticalPanel, rotation, } = props;
    const adjustedRotation = isFlipSidewaysOnVerticalPanel ? getSidewaysFlippedRotation(rotation) : rotation;
    const renderOptions = {
        height: undefined,
        width: undefined,
        rotation: adjustedRotation,
    };
    switch (scalingMode) {
        case "AutoFit":
            {
                const sizeLimit = panelHeight - margin;
                applyAutoFit(renderOptions, sizeLimit, isInHorizontalPanel, adjustedRotation);
            }
            break;
        case "PreserveOriginal":
            applyPreserveAnimationOriginalDimensions(renderOptions);
            break;
        case "Custom":
            applyCustomDimensions(renderOptions, customHeight, customWidth, isPreserveAspectRatio);
            break;
    }
    return renderOptions;
}
function getSidewaysFlippedRotation(rotation) {
    switch (rotation) {
        case 0:
            return 90;
        case 180:
            return 270;
        case 90:
        case 270:
            return rotation;
    }
}
function applyAutoFit(renderOptions, limit, isInHorizontalPanel, rotation) {
    const isRotatedSideways = rotation === 90 || rotation === 270;
    const isHeightConstrained = (isInHorizontalPanel && !isRotatedSideways) || (!isInHorizontalPanel && isRotatedSideways);
    renderOptions.height = isHeightConstrained ? limit : undefined;
    renderOptions.width = isHeightConstrained ? undefined : limit;
}
function applyPreserveAnimationOriginalDimensions(renderOptions) {
    renderOptions.height = undefined;
    renderOptions.width = undefined;
}
function applyCustomDimensions(renderOptions, customHeight, customWidth, isPreserveAspectRatio) {
    renderOptions.height = customHeight;
    renderOptions.width = customWidth;
    if (isPreserveAspectRatio) {
        renderOptions.width = undefined;
    }
}

;// ./src/utils/common/index.ts






;// ./src/AnimatedFish/AnimatedFish.ts



const { Gio, St: AnimatedFish_St, GObject } = imports.gi;
class AnimatedFishError extends Error {
    constructor(message) {
        super(message);
        this.name = "AnimatedFishError";
    }
}
const AnimatedFish = GObject.registerClass(class AnimatedFish extends AnimatedFish_St.Bin {
    constructor(props) {
        super();
        this.props = props;
        this.set_style_class_name("animated-fish");
        this.initAnimation();
    }
    update(props) {
        this.props = props;
        this.initAnimation();
    }
    updateImage(imagePath) {
        this.cleanUp();
        this.props.imagePath = imagePath;
        this.initAnimation();
    }
    updateFrames(frames) {
        this.cleanUp();
        this.props.frames = frames;
        this.initAnimation();
    }
    updatePause(pausePerFrameInMs) {
        if (!this.animation) {
            throw new AnimatedFishError("Animation has not been initialized.");
        }
        if (!isAnimationSpeedValid(pausePerFrameInMs)) {
            throw new AnimatedFishError(`Invalid frame pause (animation speed). Value: ${pausePerFrameInMs}`);
        }
        this.props.pausePerFrameInMs = pausePerFrameInMs;
        this.animation.setSpeed(pausePerFrameInMs);
    }
    updateRotate(rotation) {
        var _a, _b;
        if (!this.animation) {
            throw new AnimatedFishError("Animation has not been initialized.");
        }
        const updatedProps = { ...this.props };
        const currentRotation = (_b = (_a = updatedProps.renderOptions) === null || _a === void 0 ? void 0 : _a.rotation) !== null && _b !== void 0 ? _b : 0;
        if (currentRotation === rotation) {
            logger.logDebug(`Animation is already rotated. There is nothing to do.`);
            return;
        }
        updatedProps.renderOptions = {
            ...updatedProps.renderOptions,
            rotation,
        };
        this.update(updatedProps);
    }
    updateRenderOptions(renderOptions) {
        this.cleanUp();
        this.props.renderOptions = renderOptions;
        this.initAnimation();
    }
    enableIsFoolsDay() {
        const hastChanged = !this.props.isFoolsDay;
        this.props.isFoolsDay = true;
        if (hastChanged) {
            this.initAnimation();
        }
    }
    disableIsFoolsDay() {
        const hastChanged = this.props.isFoolsDay;
        this.props.isFoolsDay = false;
        if (hastChanged) {
            this.initAnimation();
        }
    }
    initAnimation() {
        if (this.props.isFoolsDay) {
            this.initAnimationOnFoolsDay();
        }
        else {
            this.initRegularAnimation();
        }
    }
    initRegularAnimation() {
        this.cleanUp();
        const imageFile = Gio.file_new_for_path(this.props.imagePath);
        if (!imageFile.query_exists(null)) {
            throw new AnimatedFishError(`Image does not exist: ${this.props.imagePath}`);
        }
        try {
            this.animation = new Animation({
                file: imageFile,
                frames: this.props.frames,
                speed: this.props.pausePerFrameInMs,
                renderOptions: this.props.renderOptions,
            });
            this.animation.play();
        }
        catch (error) {
            throw new AnimatedFishError(`Could not create an animation from configuration: ${error}`);
        }
        this.set_child(this.animation);
    }
    initAnimationOnFoolsDay() {
        var _a, _b;
        this.cleanUp();
        const imageFile = Gio.file_new_for_path(this.props.imagePath);
        if (!imageFile.query_exists(null)) {
            throw new AnimatedFishError(`Image does not exist: ${this.props.imagePath}`);
        }
        const currentRotation = (_b = (_a = this.props.renderOptions) === null || _a === void 0 ? void 0 : _a.rotation) !== null && _b !== void 0 ? _b : 0;
        const newRotation = ((currentRotation + 180) % 360);
        const foolsDayRenderOptions = {
            ...this.props.renderOptions,
            rotation: newRotation,
        };
        const animationProps = {
            file: imageFile,
            frames: this.props.frames,
            speed: this.props.pausePerFrameInMs,
            renderOptions: foolsDayRenderOptions,
        };
        try {
            this.animation = new Animation(animationProps);
            this.animation.pause();
        }
        catch (error) {
            throw new AnimatedFishError(`Could not create an animation from configuration: ${error}`);
        }
        this.set_child(this.animation);
    }
    cleanUp() {
        if (this.animation) {
            this.animation.destroy();
        }
    }
});

;// ./src/utils/pixbuf/image.ts
const { GdkPixbuf } = imports.gi;
function getFrameSizeOfSlicedImage(file, frames) {
    if (!Number.isInteger(frames) || frames < 0) {
        throw new Error(`Invalid frames value: ${frames}`);
    }
    const pixbuf = getPixbufFromFile(file);
    const imageWidth = pixbuf.get_width();
    const imageHeight = pixbuf.get_height();
    const frameWidth = imageWidth / frames;
    const frameHeight = imageHeight;
    if (!Number.isInteger(frameWidth) || !Number.isInteger(frameHeight)) {
        throw new Error(`Invalid frame dimensions: width=${frameWidth}, height=${frameHeight}. Ensure the image dimensions are divisible by the number of frames.`);
    }
    return {
        width: frameWidth,
        height: frameHeight,
    };
}
function getPixbufFromFile(file) {
    if (!file.query_exists(null)) {
        throw new Error(`File does not exist: ${file}`);
    }
    const filePath = file.get_path();
    if (!filePath) {
        throw new Error(`File path is null.`);
    }
    const pixbuf = GdkPixbuf.Pixbuf.new_from_file(filePath);
    if (!pixbuf) {
        throw new Error(`Failed to load image from file: ${file}`);
    }
    return pixbuf;
}
function getPixbufFromFileAtScale(file, width, height, preserveAspectRatio) {
    if (!file.query_exists(null)) {
        throw new Error(`File does not exist: ${file}`);
    }
    const filePath = file.get_path();
    if (!filePath) {
        throw new Error(`File path is null.`);
    }
    if (height !== -1 && height < 1) {
        throw new Error(`Invalid image height value: ${height}`);
    }
    if (width !== -1 && width < 1) {
        throw new Error(`Invalid image width value: ${width}`);
    }
    const pixbuf = GdkPixbuf.Pixbuf.new_from_file_at_scale(filePath, width, height, preserveAspectRatio);
    if (!pixbuf) {
        throw new Error(`Failed to load image from file: ${file}`);
    }
    return pixbuf;
}

;// ./src/utils/pixbuf/index.ts


;// ./src/AnimatedFish/Animation/cairo-surface/Animation.ts


const { St: Animation_St, GLib: Animation_GLib, GObject: Animation_GObject, Gdk } = imports.gi;
class AnimationError extends Error {
    constructor(message) {
        super(message);
        this.name = "AnimationError";
    }
}
const Animation = Animation_GObject.registerClass(class Animation extends Animation_St.Bin {
    constructor(animationProps) {
        const { file, frames, speed, renderOptions } = animationProps;
        super();
        this.set_style_class_name("animation");
        this.file = file;
        if (frames < 1 || !Number.isInteger(frames)) {
            throw new AnimationError(`Invalid frame count. Value: ${frames}`);
        }
        this.frames = frames;
        if (!isAnimationSpeedValid(speed)) {
            throw new AnimationError(`Animation speed is invalid. Value: ${speed}`);
        }
        this.speed = speed;
        this.renderOptions = renderOptions;
        this.timeoutId = 0;
        this.frame = 0;
        try {
            this.loadRenderData();
        }
        catch (error) {
            throw new AnimationError(`Could not load image data: ${error}`);
        }
        this.drawingArea = new Animation_St.DrawingArea();
        this.drawingArea.set_size(this.renderData.frameWidth, this.renderData.frameHeight);
        this.drawingArea.connect("repaint", this.onRepaint.bind(this));
        this.set_child(this.drawingArea);
        this.connect("destroy", () => this.onDestroy());
        this.isLoaded = true;
    }
    setSpeed(speed) {
        if (!isAnimationSpeedValid(speed)) {
            throw new AnimationError(`Animation speed is invalid. Value: ${speed}`);
        }
        this.stop();
        this.speed = speed;
        this.play();
    }
    play() {
        if (this.isLoaded && this.timeoutId === 0) {
            if (this.frame === 0) {
                this.showFrame(0);
            }
            this.timeoutId = Animation_GLib.timeout_add(Animation_GLib.PRIORITY_LOW, this.speed, this.update.bind(this));
            Animation_GLib.Source.set_name_by_id(this.timeoutId, `[cinnamon] this.update`);
        }
    }
    stop() {
        if (this.timeoutId > 0) {
            Animation_GLib.source_remove(this.timeoutId);
            this.timeoutId = 0;
        }
    }
    pause() {
        if (this.timeoutId > 0) {
            Animation_GLib.source_remove(this.timeoutId);
            this.timeoutId = 0;
        }
    }
    resume() {
        this.play();
    }
    showFrame(frame) {
        this.frame = frame % this.frames;
    }
    update() {
        this.showFrame(this.frame + 1);
        this.drawingArea.queue_repaint();
        return Animation_GLib.SOURCE_CONTINUE;
    }
    loadRenderData() {
        var _a;
        let pixbufWidth;
        let pixbufHeight;
        let preserveAspectRatio;
        let pixbufRotation;
        if (!this.renderOptions) {
            pixbufWidth = -1;
            pixbufHeight = -1;
            preserveAspectRatio = true;
            pixbufRotation = undefined;
        }
        else {
            pixbufWidth = this.renderOptions.width ? this.renderOptions.width * this.frames : -1;
            pixbufHeight = (_a = this.renderOptions.height) !== null && _a !== void 0 ? _a : -1;
            preserveAspectRatio = this.renderOptions.width === undefined || this.renderOptions.height === undefined;
            pixbufRotation =
                this.renderOptions.rotation !== undefined
                    ? mapAnimationRotationToPixbufRotation(this.renderOptions.rotation)
                    : undefined;
        }
        let rotation;
        if (this.renderOptions && this.renderOptions.rotation) {
            rotation = this.renderOptions.rotation;
        }
        else {
            rotation = 0;
        }
        let pixbuf = getPixbufFromFileAtScale(this.file, pixbufWidth, pixbufHeight, preserveAspectRatio);
        if (pixbufRotation) {
            const rotated_pixbuf = pixbuf.rotate_simple(pixbufRotation);
            if (rotated_pixbuf) {
                pixbuf = rotated_pixbuf;
            }
            else {
                throw new AnimationError(`Image rotation failed.`);
            }
        }
        const surface = Gdk.cairo_surface_create_from_pixbuf(pixbuf, 1, null);
        let frameWidth;
        let frameHeight;
        switch (rotation) {
            case 0:
            case 180:
                frameWidth = Math.round(pixbuf.get_width() / this.frames);
                frameHeight = pixbuf.get_height();
                break;
            case 90:
            case 270:
                frameWidth = pixbuf.get_width();
                frameHeight = Math.round(pixbuf.get_height() / this.frames);
                break;
            default:
                throw new AnimationError(`Invalid rotation value: ${rotation}`);
        }
        const renderData = {
            surface,
            frameWidth,
            frameHeight,
            rotation,
        };
        this.renderData = renderData;
    }
    onRepaint(area) {
        const cr = area.get_context();
        cr.save();
        let imageOffset;
        switch (this.renderData.rotation) {
            case 0:
                imageOffset = this.frame * this.renderData.frameWidth;
                cr.setSourceSurface(this.renderData.surface, -imageOffset, 0);
                break;
            case 180:
                {
                    const currentFrame = this.frames - 1 - this.frame;
                    imageOffset = currentFrame * this.renderData.frameWidth;
                    cr.setSourceSurface(this.renderData.surface, -imageOffset, 0);
                }
                break;
            case 90:
                imageOffset = this.frame * this.renderData.frameHeight;
                cr.setSourceSurface(this.renderData.surface, 0, -imageOffset);
                break;
            case 270:
                {
                    const currentFrame = this.frames - 1 - this.frame;
                    imageOffset = currentFrame * this.renderData.frameHeight;
                    cr.setSourceSurface(this.renderData.surface, 0, -imageOffset);
                }
                break;
            default:
                throw new AnimationError(`Invalid rotation value: ${this.renderData.rotation}`);
        }
        cr.getSource().setFilter(imports.gi.cairo.Filter.BEST);
        cr.setOperator(imports.gi.cairo.Operator.SOURCE);
        cr.paint();
        cr.restore();
        cr.$dispose();
    }
    onDestroy() {
        this.stop();
    }
});
function mapAnimationRotationToPixbufRotation(rotation) {
    switch (rotation) {
        case 0:
            return imports.gi.GdkPixbuf.PixbufRotation.NONE;
        case 90:
            return imports.gi.GdkPixbuf.PixbufRotation.COUNTERCLOCKWISE;
        case 180:
            return imports.gi.GdkPixbuf.PixbufRotation.UPSIDEDOWN;
        case 270:
            return imports.gi.GdkPixbuf.PixbufRotation.CLOCKWISE;
        default:
            throw new Error(`Invalid rotation value: ${rotation}`);
    }
}

;// ./src/AnimatedFish/index.ts



;// ./src/PopupMenu/BasePopupMenu.ts
const { AppletPopupMenu } = imports.ui.applet;
class BasePopupMenu extends AppletPopupMenu {
    constructor(launcher, orientation) {
        super(launcher, orientation);
        this.actor.add_style_class_name("fish-menu");
    }
    addStyleClassName(className) {
        this.actor.add_style_class_name(className);
    }
    removeStyleClassName(className) {
        this.actor.remove_style_class_name(className);
    }
}

;// ./src/utils/translation/translation.ts

const Gettext = imports.gettext;
function _(text) {
    const translated = Gettext.dgettext(UUID, text);
    if (translated !== text) {
        return translated;
    }
    return Gettext.gettext(text);
}

;// ./src/utils/translation/index.ts


;// ./src/utils/icons/icons.ts
const { St: icons_St } = imports.gi;
const ErrorIcon = (iconsSize = 24) => new icons_St.Icon({
    icon_name: "error",
    icon_type: icons_St.IconType.SYMBOLIC,
    icon_size: iconsSize,
});
const InfoIcon = (iconsSize = 24) => new icons_St.Icon({
    icon_name: "info",
    icon_type: icons_St.IconType.SYMBOLIC,
    icon_size: iconsSize,
});

;// ./src/utils/icons/index.ts


;// ./src/utils/notification/notification.ts

const { MessageTray, SystemNotificationSource, Notification, Urgency } = imports.ui.messageTray;
const Main = imports.ui.main;
const messageTray = new MessageTray();
function showNotification(props) {
    const { message, title = _("Fish Applet"), isPersistent = false, buttons = [] } = props;
    const source = new SystemNotificationSource(title);
    if (Main.messageTray) {
        messageTray.add(source);
        const notification = new Notification(source, title, message);
        notification.setTransient(true);
        notification.setUrgency(isPersistent ? Urgency.CRITICAL : Urgency.NORMAL);
        if (buttons.length !== 0) {
            const actionIdPrefix = "notification-button-";
            buttons.forEach((button, index) => {
                const actionId = actionIdPrefix + index;
                notification.addButton(actionId, button.label);
            });
            notification.connect("action-invoked", (_, actionId) => {
                const buttonIndex = parseInt(actionId.split(actionIdPrefix)[1], 10);
                if (buttonIndex >= 0 && buttonIndex < buttons.length) {
                    buttons[buttonIndex].callback();
                }
            });
        }
        source.notify(notification);
    }
}

;// ./src/utils/notification/index.ts


;// ./src/PopupMenu/ErrorPopupMenu.ts




const { St: ErrorPopupMenu_St, Pango } = imports.gi;
class ErrorPopupMenu extends BasePopupMenu {
    constructor(props) {
        const { launcher, orientation, errors, onOpenPreferences } = props;
        super(launcher, orientation);
        this.errors = [];
        this.errors = errors;
        const popupContainer = new ErrorPopupMenu_St.BoxLayout({
            vertical: true,
            style_class: "fish-popup-container fish-error-popup",
        });
        const mainContainer = new ErrorPopupMenu_St.BoxLayout({
            style_class: "main-container",
        });
        const errorIcon = ErrorIcon(48);
        errorIcon.set_y_align(imports.gi.Clutter.ActorAlign.START);
        mainContainer.add(errorIcon);
        const messageContainer = new ErrorPopupMenu_St.BoxLayout({
            vertical: true,
            style_class: "message-container",
        });
        mainContainer.add(messageContainer);
        popupContainer.add(mainContainer);
        const titleLabel = new ErrorPopupMenu_St.Label({
            style_class: "header-label",
            text: _("There's something fishy going on here:"),
        });
        messageContainer.add(titleLabel);
        const errorMessagesScrollContainer = new ErrorPopupMenu_St.ScrollView({
            style_class: "error-messages-scroll-container",
            hscrollbar_policy: ErrorPopupMenu_St.PolicyType.AUTOMATIC,
            vscrollbar_policy: ErrorPopupMenu_St.PolicyType.AUTOMATIC,
            overlay_scrollbars: false,
            enable_mouse_scrolling: true,
            enable_auto_scrolling: false,
            x_fill: false,
            y_fill: false,
            x_expand: true,
            y_expand: true,
            y_align: ErrorPopupMenu_St.Align.MIDDLE,
            x_align: ErrorPopupMenu_St.Align.MIDDLE,
        });
        messageContainer.add(errorMessagesScrollContainer);
        const errorMessagesBox = new ErrorPopupMenu_St.BoxLayout({
            style_class: "error-messages-box",
        });
        errorMessagesScrollContainer.add_actor(errorMessagesBox);
        const errorMessagesLabel = new ErrorPopupMenu_St.Label({
            style_class: "error-messages-label",
            text: this.getAllErrorMessages(),
        });
        const messageClutterText = errorMessagesLabel.get_clutter_text();
        messageClutterText.set_ellipsize(Pango.EllipsizeMode.NONE);
        messageClutterText.set_line_wrap_mode(Pango.WrapMode.WORD_CHAR);
        errorMessagesBox.add(errorMessagesLabel);
        const buttonContainer = new ErrorPopupMenu_St.BoxLayout({
            style_class: "button-container",
        });
        const buttonContainerLeft = new ErrorPopupMenu_St.BoxLayout({
            x_align: imports.gi.Clutter.ActorAlign.START,
            y_align: imports.gi.Clutter.ActorAlign.CENTER,
            x_expand: true,
            y_expand: true,
        });
        let copyButtonText;
        if (this.errors.length > 1) {
            copyButtonText = _("Copy Error Messages");
        }
        else {
            copyButtonText = _("Copy Error Message");
        }
        const copyButton = new ErrorPopupMenu_St.Button({
            label: copyButtonText,
            style_class: "applet-box",
        });
        copyButton.connect("clicked", this.onCopy.bind(this));
        buttonContainerLeft.add(copyButton);
        buttonContainer.add(buttonContainerLeft);
        const buttonContainerRight = new ErrorPopupMenu_St.BoxLayout({
            x_align: imports.gi.Clutter.ActorAlign.END,
            y_align: imports.gi.Clutter.ActorAlign.CENTER,
            x_expand: true,
            y_expand: true,
        });
        const openPreferencesButton = new ErrorPopupMenu_St.Button({
            label: _("Open Preferences"),
            style_class: "applet-box",
        });
        openPreferencesButton.connect("clicked", onOpenPreferences);
        buttonContainerRight.add(openPreferencesButton);
        buttonContainer.add(buttonContainerRight);
        popupContainer.add(buttonContainer);
        this.box.add(popupContainer);
    }
    onCopy() {
        let notificationText;
        if (this.errors.length > 1) {
            notificationText = _("Errors copied to the clipboard");
        }
        else {
            notificationText = _("Error copied to the clipboard");
        }
        ErrorPopupMenu_St.Clipboard.get_default().set_text(ErrorPopupMenu_St.ClipboardType.CLIPBOARD, this.getAllErrorMessages());
        showNotification({ message: notificationText });
    }
    getAllErrorMessages() {
        return this.errors.map((error) => error.message).join("\n\n");
    }
}

;// ./src/PopupMenu/FishMessagePopupMenu.ts



const { St: FishMessagePopupMenu_St, Pango: FishMessagePopupMenu_Pango } = imports.gi;
class FishMessagePopupMenu extends BasePopupMenu {
    constructor(props) {
        const { launcher, orientation, name, message, onSpeakAgain, onClose } = props;
        super(launcher, orientation);
        this.name = "";
        this.message = "";
        if (name) {
            this.name = name;
        }
        if (message) {
            this.message = message;
        }
        const popupContainer = new FishMessagePopupMenu_St.BoxLayout({
            vertical: true,
            style_class: "fish-popup-container fish-message-popup",
        });
        this.titleLabel = new FishMessagePopupMenu_St.Label({
            style_class: "header-label",
        });
        this.setTitle();
        popupContainer.add(this.titleLabel);
        const messageScrollContainer = new FishMessagePopupMenu_St.ScrollView({
            style_class: "message-scroll-container",
            hscrollbar_policy: FishMessagePopupMenu_St.PolicyType.AUTOMATIC,
            vscrollbar_policy: FishMessagePopupMenu_St.PolicyType.AUTOMATIC,
            overlay_scrollbars: false,
            enable_mouse_scrolling: true,
            enable_auto_scrolling: false,
            x_fill: false,
            y_fill: false,
            x_expand: true,
            y_expand: true,
            y_align: FishMessagePopupMenu_St.Align.MIDDLE,
            x_align: FishMessagePopupMenu_St.Align.MIDDLE,
        });
        const messageBox = new FishMessagePopupMenu_St.BoxLayout({
            style_class: "message-box",
        });
        this.messageLabel = new FishMessagePopupMenu_St.Label({
            style_class: "message-label",
        });
        const messageClutterText = this.messageLabel.get_clutter_text();
        messageClutterText.set_ellipsize(FishMessagePopupMenu_Pango.EllipsizeMode.NONE);
        messageClutterText.set_line_wrap_mode(FishMessagePopupMenu_Pango.WrapMode.WORD_CHAR);
        this.setMessage();
        messageBox.add(this.messageLabel);
        messageScrollContainer.add_actor(messageBox);
        popupContainer.add(messageScrollContainer);
        const buttonContainer = new FishMessagePopupMenu_St.BoxLayout({
            style_class: "button-container",
        });
        const buttonContainerLeft = new FishMessagePopupMenu_St.BoxLayout({
            x_align: imports.gi.Clutter.ActorAlign.START,
            y_align: imports.gi.Clutter.ActorAlign.CENTER,
            x_expand: true,
            y_expand: true,
        });
        const copyButton = new FishMessagePopupMenu_St.Button({
            label: _("Copy Message"),
            style_class: "applet-box",
        });
        copyButton.connect("clicked", this.onCopy.bind(this));
        buttonContainerLeft.add(copyButton);
        const buttonContainerRight = new FishMessagePopupMenu_St.BoxLayout({
            x_align: imports.gi.Clutter.ActorAlign.END,
            y_align: imports.gi.Clutter.ActorAlign.CENTER,
            x_expand: true,
            y_expand: true,
        });
        const speakAgainButton = new FishMessagePopupMenu_St.Button({
            label: _("Speak again"),
            style_class: "applet-box",
        });
        speakAgainButton.connect("clicked", onSpeakAgain);
        const closeButton = new FishMessagePopupMenu_St.Button({
            label: _("Close"),
            style_class: "applet-box",
        });
        closeButton.connect("clicked", onClose);
        buttonContainerRight.add(speakAgainButton);
        buttonContainerRight.add(closeButton);
        buttonContainer.add(buttonContainerLeft);
        buttonContainer.add(buttonContainerRight);
        popupContainer.add(buttonContainer);
        this.box.add(popupContainer);
    }
    updateName(fishName) {
        this.name = fishName;
        this.setTitle();
    }
    updateMessage(message) {
        this.message = message;
        this.setMessage();
    }
    setTitle() {
        const title = _("%s the Fish Says:").format(this.name);
        this.titleLabel.set_text(title);
    }
    setMessage() {
        this.messageLabel.set_text(this.message);
    }
    onCopy() {
        FishMessagePopupMenu_St.Clipboard.get_default().set_text(FishMessagePopupMenu_St.ClipboardType.CLIPBOARD, this.message);
        showNotification({ message: _("Message copied to the clipboard") });
    }
}

;// ./src/PopupMenu/FoolsDayPopupMenu.ts



const { St: FoolsDayPopupMenu_St } = imports.gi;
class FoolsDayPopupMenu extends BasePopupMenu {
    constructor(props) {
        const { launcher, orientation } = props;
        super(launcher, orientation);
        const popupContainer = new FoolsDayPopupMenu_St.BoxLayout({
            vertical: true,
            style_class: "fish-popup-container fish-fools-day-popup",
        });
        const mainContainer = new FoolsDayPopupMenu_St.BoxLayout({
            style_class: "main-container",
        });
        const icon = InfoIcon(48);
        mainContainer.add(icon);
        const messageContainer = new FoolsDayPopupMenu_St.BoxLayout({
            vertical: true,
            style_class: "message-container",
        });
        const messageLabel = new FoolsDayPopupMenu_St.Label({
            style_class: "message-label",
            text: _("The water needs changing"),
        });
        messageContainer.add(messageLabel);
        const secondaryMessageLabel = new FoolsDayPopupMenu_St.Label({
            style_class: "secondary-message-label",
            text: _("Look at today's date!"),
        });
        messageContainer.add(secondaryMessageLabel);
        mainContainer.add(messageContainer);
        popupContainer.add(mainContainer);
        this.box.add(popupContainer);
    }
}

;// ./src/PopupMenu/PopupMenuFactory.ts



class PopupMenuFactory {
    static createPopupMenu(props) {
        const { popupMenuType, popupMenuProps, popupMenuOptions } = props;
        let popupMenu;
        switch (popupMenuType) {
            case "FishMessage":
                popupMenu = new FishMessagePopupMenu(popupMenuProps);
                break;
            case "FoolsDay":
                popupMenu = new FoolsDayPopupMenu(popupMenuProps);
                break;
            case "Error":
                popupMenu = new ErrorPopupMenu(popupMenuProps);
                break;
            default:
                throw new Error("Unknown popup menu type");
        }
        if (popupMenuOptions === null || popupMenuOptions === void 0 ? void 0 : popupMenuOptions.styleClassName) {
            popupMenu.addStyleClassName(popupMenuOptions.styleClassName);
        }
        return popupMenu;
    }
}

;// ./src/PopupMenu/index.ts






;// ./src/FishApplet/ErrorManager/FishAppletErrorManager.ts
class FishAppletErrorManager {
    constructor() {
        this.errors = {};
    }
    addError(error) {
        var _a;
        if (!this.errors[error.location]) {
            this.errors[error.location] = [];
        }
        (_a = this.errors[error.location]) === null || _a === void 0 ? void 0 : _a.push(error);
    }
    getError(location) {
        return this.errors[location];
    }
    getAllErrors() {
        const allErrors = [];
        for (const location in this.errors) {
            if (Object.prototype.hasOwnProperty.call(this.errors, location)) {
                const errorsAtLocation = this.errors[location];
                if (errorsAtLocation) {
                    allErrors.push(...errorsAtLocation);
                }
            }
        }
        return allErrors;
    }
    deleteError(location) {
        delete this.errors[location];
    }
    hasError(location) {
        const errorsAtLocation = this.errors[location];
        return errorsAtLocation !== undefined && errorsAtLocation.length > 0;
    }
    hasErrors() {
        return Object.keys(this.errors).length !== 0;
    }
}

;// ./src/FishApplet/FishApplet.ts









const { Applet, AllowedLayout } = imports.ui.applet;
const { AppletSettings } = imports.ui.settings;
const { PopupMenuManager } = imports.ui.popupMenu;
const { SignalManager } = imports.misc.signalManager;
const { themeManager } = imports.ui.main;
const { GLib: FishApplet_GLib } = imports.gi;
const Mainloop = imports.mainloop;
const FOOLS_DAY_CHECK_INTERVAL_IN_MS = 60000;
const FORTUNE_COMMAND = "fortune";
const DEFAULT_APPLET_CLASS_NAME = "applet-box";
class FishApplet extends Applet {
    constructor(metadata, orientation, panelHeight, instanceId) {
        super(orientation, panelHeight, instanceId);
        this.settingsObject = {};
        this.metadata = metadata;
        this.uuid = metadata.uuid;
        this.orientation = orientation;
        this.panelHeight = panelHeight;
        this.instanceId = instanceId;
        this.setAllowedLayout(AllowedLayout.BOTH);
        this.actor.add_style_class_name("fish-applet");
        this.isFoolsDay = false;
        this.foolsDayTimeoutId = 0;
        this.startPeriodicFoolsDayCheck();
        this.errorManager = new FishAppletErrorManager();
        this.lastCommandOutput = "";
        this.bindSettings();
        this.updateLogLevel();
        this.initApplet();
    }
    on_panel_height_changed() {
        this.panelHeight = this._panelHeight;
        this.initAnimation();
        this.updateApplet();
    }
    on_applet_removed_from_panel() {
        var _a;
        (_a = this.animatedFish) === null || _a === void 0 ? void 0 : _a.destroy();
        this.stopPeriodicFoolsDayCheck();
    }
    on_applet_clicked(_) {
        this.messagePopup.toggle();
        return false;
    }
    on_orientation_changed(orientation) {
        this.orientation = orientation;
        const isFlipSidewaysOnVerticalPanel = this.settingsObject.flipSidewaysOnVerticalPanel;
        this.updateFlipSidewaysOnVerticalPanel(isFlipSidewaysOnVerticalPanel);
    }
    initApplet() {
        const expandedPath = expandHomeDir(this.settings.getValue("keyImagePath"));
        this.settings.setValue("keyImagePath", expandedPath);
        this.settingsObject.imagePath = this.settings.getValue("keyImagePath");
        this.signalManager = new SignalManager();
        this.signalManager.connect(themeManager, "theme-set", this.changeTheme.bind(this), this);
        this.initAnimation();
        this.menuManager = new PopupMenuManager(this);
        this.updateMessagePopup();
        this.updateName();
        this.updateCommand();
    }
    updateMessagePopup() {
        let popupMenuType;
        if (this.errorManager.hasErrors()) {
            popupMenuType = "Error";
        }
        else if (this.isFoolsDay) {
            popupMenuType = "FoolsDay";
        }
        else {
            popupMenuType = "FishMessage";
        }
        this.setActivePopup(popupMenuType);
    }
    setActivePopup(popupMenuType) {
        if (popupMenuType === "Error" && !this.errorManager.hasErrors()) {
            return;
        }
        if (this.isTargetPopupMenuAlreadyActive(popupMenuType)) {
            return;
        }
        let popupMenuProps;
        switch (popupMenuType) {
            case "FishMessage":
                popupMenuProps = {
                    popupMenuType: "FishMessage",
                    popupMenuProps: {
                        launcher: this,
                        orientation: this.orientation,
                        name: this.settingsObject.name,
                        message: this.lastCommandOutput,
                        onSpeakAgain: this.runCommand.bind(this),
                        onClose: () => this.messagePopup.close(true),
                    },
                };
                break;
            case "FoolsDay":
                popupMenuProps = {
                    popupMenuType: "FoolsDay",
                    popupMenuProps: {
                        launcher: this,
                        orientation: this.orientation,
                    },
                };
                break;
            case "Error":
                popupMenuProps = {
                    popupMenuType: "Error",
                    popupMenuProps: {
                        launcher: this,
                        orientation: this.orientation,
                        errors: this.errorManager.getAllErrors(),
                        onOpenPreferences: () => {
                            this.messagePopup.close(true);
                            this.configureApplet();
                        },
                    },
                };
                break;
            default:
                throw new Error("Unknown popup menu type");
        }
        if (this.isDarkMode()) {
            const styleClassName = "dark";
            popupMenuProps.popupMenuOptions = {
                ...popupMenuProps.popupMenuOptions,
                styleClassName,
            };
        }
        if (this.messagePopup) {
            this.menuManager.removeMenu(this.messagePopup);
            this.messagePopup.destroy();
        }
        this.messagePopup = PopupMenuFactory.createPopupMenu(popupMenuProps);
        this.menuManager.addMenu(this.messagePopup);
    }
    isTargetPopupMenuAlreadyActive(targetPopupMenuTyp) {
        switch (targetPopupMenuTyp) {
            case "FishMessage":
                if (this.messagePopup instanceof FishMessagePopupMenu) {
                    return true;
                }
                else {
                    return false;
                }
            case "FoolsDay":
                if (this.messagePopup instanceof FoolsDayPopupMenu) {
                    return true;
                }
                else {
                    return false;
                }
            case "Error":
                if (this.messagePopup instanceof ErrorPopupMenu) {
                    return true;
                }
                else {
                    return false;
                }
            default:
                throw new Error("Unknown popup menu type");
        }
    }
    runCommand() {
        if (this.errorManager.hasError("command")) {
            return;
        }
        this.errorManager.deleteError("commandExecution");
        const command = this.settingsObject.command;
        runCommandAsyncIO(command, (message) => {
            if (this.messagePopup instanceof FishMessagePopupMenu) {
                this.messagePopup.updateMessage(message);
            }
            this.lastCommandOutput = message;
        }, (error) => {
            this.handleError(error, "commandExecution");
        });
    }
    bindSettings() {
        this.settings = new AppletSettings(this.settingsObject, this.uuid, this.instanceId);
        this.settings.bind("keyNameOfFish", "name", this.updateName.bind(this));
        this.settings.bind("keyCommand", "command", this.updateCommand.bind(this));
        this.settings.bind("keyFrames", "frames", this.updateAnimationFrames.bind(this));
        this.settings.bind("keyPausePerFrameInSeconds", "pausePerFrameInSeconds", this.updateAnimationPause.bind(this));
        this.settings.bind("keyFlipSidewaysOnVerticalPanel", "flipSidewaysOnVerticalPanel", this.updateFlipSidewaysOnVerticalPanel.bind(this));
        this.settings.connect("changed::keyImagePath", () => {
            const newValue = this.settings.getValue("keyImagePath");
            this.settingsObject.imagePath = newValue;
            this.updateAnimationImage(newValue);
        });
        this.settings.bind("keyAnimationScalingMode", "animationScalingMode", this.updateAnimationScalingMode.bind(this));
        this.settings.bind("keyAnimationAutoMargin", "autoAnimationMargin", this.updateAnimationAutoMargin.bind(this));
        this.settings.bind("keyAnimationMargin", "customAnimationMargin", this.updateAnimationMargin.bind(this));
        this.settings.bind("keyAnimationHeight", "customAnimationHeight", this.updateCustomAnimationHeight.bind(this));
        this.settings.bind("keyAnimationWidth", "customAnimationWidth", this.updateCustomAnimationWidth.bind(this));
        this.settings.bind("keyAnimationPreserveAspectRatio", "preserveAnimationAspectRatio", this.updatePreserveAnimationAspectRatio.bind(this));
        this.settings.bind("keyAnimationRotation", "animationRotation", this.updateAnimationRotation.bind(this));
        this.settings.bind("keyDeveloperOptionsEnabled", "developerOptionsEnabled");
        this.settings.bind("keyLogLevel", "logLevel", this.updateLogLevel.bind(this));
        this.settings.bind("keyForceFoolsDay", "forceFoolsDay", this.updateForceFoolsDay.bind(this));
    }
    openCinnamonSpicesWebsite() {
        openWebsite(FISH_APPLET_CINNAMON_SPICES_WEBSITE);
    }
    openReportBugsInstructions() {
        openWebsite(REPORT_BUGS_INSTRUCTIONS_WEBSITE);
    }
    updateName() {
        const tooltipText = _("%s the Fish, the fortune teller").format(this.settingsObject.name);
        this.set_applet_tooltip(tooltipText);
        if (this.messagePopup instanceof FishMessagePopupMenu) {
            this.messagePopup.updateName(this.settingsObject.name);
        }
    }
    updateCommand() {
        const commandLine = this.settingsObject.command;
        const name = this.settingsObject.name;
        this.errorManager.deleteError("command");
        try {
            const [success, argv] = FishApplet_GLib.shell_parse_argv(commandLine);
            if (!success || !argv) {
                throw new Error(`Could not parse command. Command: ${commandLine}`);
            }
            const program = argv[0];
            if (KNOWN_USEFUL_PROGRAMS.includes(program)) {
                const commandWarningMessage = _(`Warning: The command appears to be something actually useful. 
Since this is a useless applet, you may not want to do this. 
We strongly advise you against using %s for anything which would make the applet "practical" or useful.`).format(name);
                logger.logWarning(commandWarningMessage);
                showNotification({ message: commandWarningMessage, type: "Warning", isPersistent: true });
            }
            if (FishApplet_GLib.find_program_in_path(program) == null) {
                if (program === FORTUNE_COMMAND) {
                    const fortuneNotInstalledMessage = _(`Normally, the Fish's wisdom is derived from the 'fortune' command-line utility. 
It seems that this dependency is missing on your system.
However, it should be available for most distributions. 
Please refer to the documentation for instructions on how to install it. 
If you prefer not to install any additional packages, you can change the command in the applet's settings.`);
                    logger.logError(fortuneNotInstalledMessage);
                    const buttons = [
                        {
                            label: _("Open Documentation"),
                            callback: () => openWebsite(FISH_APPLET_CINNAMON_SPICES_WEBSITE),
                        },
                        {
                            label: _("Open Preferences"),
                            callback: () => this.configureApplet(),
                        },
                    ];
                    showNotification({ message: fortuneNotInstalledMessage, type: "Warning", isPersistent: true, buttons });
                    throw new Error("The 'fortune' command-line utility is missing. Please install it or update the applet's settings.");
                }
                else {
                    throw new Error("Unable to locate the command to execute");
                }
            }
            this.updateApplet();
            this.runCommand();
        }
        catch (error) {
            this.handleError(error, "command");
        }
    }
    determineAnimationRenderOptions() {
        return determineRenderOptionsFromSettings({
            isInHorizontalPanel: isHorizontalOriented(this.orientation),
            panelHeight: this.panelHeight,
            scalingMode: mapStringToAnimationScalingMode(this.settingsObject.animationScalingMode),
            margin: this.getAppletMargin(),
            customHeight: this.settingsObject.customAnimationHeight,
            customWidth: this.settingsObject.customAnimationWidth,
            isPreserveAspectRatio: this.settingsObject.preserveAnimationAspectRatio,
            isFlipSidewaysOnVerticalPanel: this.settingsObject.flipSidewaysOnVerticalPanel,
            rotation: mapNumberToAnimationRotation(this.settingsObject.animationRotation),
        });
    }
    initAnimation() {
        try {
            this.errorManager.deleteError("animation");
            const configuration = {
                imagePath: this.settingsObject.imagePath,
                frames: this.settingsObject.frames,
                pausePerFrameInMs: Math.floor(this.settingsObject.pausePerFrameInSeconds * 1000),
                renderOptions: this.determineAnimationRenderOptions(),
                isFoolsDay: this.isFoolsDay,
            };
            if (this.animatedFish === undefined) {
                this.animatedFish = new AnimatedFish(configuration);
            }
            else {
                this.animatedFish.update(configuration);
            }
        }
        catch (error) {
            this.handleError(error, "animation");
        }
    }
    updateAnimationImage(imagePath) {
        this.errorManager.deleteError("animation");
        try {
            if (!this.animatedFish) {
                this.initAnimation();
            }
            else {
                this.animatedFish.updateImage(imagePath);
            }
            this.updateApplet();
        }
        catch (error) {
            this.handleError(error, "animation");
        }
    }
    updateAnimationFrames(frames) {
        this.errorManager.deleteError("animation");
        try {
            if (!this.animatedFish) {
                this.initAnimation();
            }
            else {
                this.animatedFish.updateFrames(frames);
            }
            this.updateApplet();
        }
        catch (error) {
            this.handleError(error, "animation");
        }
    }
    updateAnimationPause(pauseInSeconds) {
        this.errorManager.deleteError("animation");
        try {
            if (!this.animatedFish) {
                this.initAnimation();
            }
            else {
                const pauseInMilliseconds = Math.floor(pauseInSeconds * 1000);
                this.animatedFish.updatePause(pauseInMilliseconds);
            }
            this.updateApplet();
        }
        catch (error) {
            this.handleError(error, "animation");
        }
    }
    updateFlipSidewaysOnVerticalPanel(isFlipSidewaysOnVerticalPanel) {
        if (isFlipSidewaysOnVerticalPanel && isHorizontalOriented(this.orientation)) {
            logger.logWarning("Flip sideways option works only when the applet is placed on a vertical panel.");
            return;
        }
        this.errorManager.deleteError("animation");
        try {
            if (!this.animatedFish) {
                this.initAnimation();
            }
            else {
                const updatedRenderOptions = this.determineAnimationRenderOptions();
                this.animatedFish.updateRenderOptions(updatedRenderOptions);
            }
            this.updateApplet();
        }
        catch (error) {
            this.handleError(error, "animation");
        }
    }
    updateAnimationScalingMode() {
        this.initAnimation();
        this.updateApplet();
    }
    updateAnimationAutoMargin() {
        const scalingMode = mapStringToAnimationScalingMode(this.settingsObject.animationScalingMode);
        if (scalingMode !== "AutoFit") {
            logger.logDebug("Margin options only apply when the 'auto-fit' animation scaling option is enabled.");
        }
        else {
            this.initAnimation();
            this.updateApplet();
        }
    }
    updateAnimationMargin() {
        const scalingMode = mapStringToAnimationScalingMode(this.settingsObject.animationScalingMode);
        if (scalingMode !== "AutoFit") {
            logger.logDebug("Margin options only apply when the 'auto-fit' animation scaling option is enabled.");
        }
        else if (this.settingsObject.autoAnimationMargin) {
            logger.logDebug("The 'auto-margin' option is turned on, so the custom margin value is ignored.");
        }
        else {
            this.initAnimation();
            this.updateApplet();
        }
    }
    updateCustomAnimationHeight() {
        const scalingMode = mapStringToAnimationScalingMode(this.settingsObject.animationScalingMode);
        if (scalingMode !== "Custom") {
            logger.logDebug("Custom height options only apply when the 'custom' animation scaling option is enabled.");
        }
        else {
            this.initAnimation();
            this.updateApplet();
        }
    }
    updateCustomAnimationWidth() {
        const scalingMode = mapStringToAnimationScalingMode(this.settingsObject.animationScalingMode);
        if (scalingMode !== "Custom") {
            logger.logDebug("Custom width options only apply when the 'custom' animation scaling option is enabled.");
        }
        else {
            this.initAnimation();
            this.updateApplet();
        }
    }
    updatePreserveAnimationAspectRatio() {
        const scalingMode = mapStringToAnimationScalingMode(this.settingsObject.animationScalingMode);
        if (scalingMode !== "Custom") {
            logger.logDebug("The 'Preserve aspect ratio' option only apply when the 'custom' animation scaling option is used.");
        }
        else {
            this.initAnimation();
            this.updateApplet();
        }
    }
    updateAnimationRotation() {
        this.initAnimation();
        this.updateApplet();
    }
    updateLogLevel() {
        const logLevel = mapStringToLogLevel(this.settingsObject.logLevel);
        logger.setLogLevel(logLevel);
    }
    updateForceFoolsDay() {
        const isActivated = this.settingsObject.forceFoolsDay;
        if (isActivated) {
            this.stopPeriodicFoolsDayCheck();
            this.isFoolsDay = true;
            this.initAnimation();
            this.updateApplet();
        }
        else {
            this.startPeriodicFoolsDayCheck();
        }
    }
    updateApplet() {
        if (this.errorManager.hasErrors()) {
            return;
        }
        this.actor.remove_all_children();
        if (this.animatedFish) {
            this.actor.add_child(this.animatedFish);
        }
        this.updateMessagePopup();
    }
    handleError(error, location) {
        let message = "";
        if (error instanceof Error) {
            message = error.message;
        }
        else {
            message = "Unknown error";
        }
        logger.logError(message, error);
        const fishAppletError = {
            type: "Error",
            location: location,
            message: message,
        };
        this.errorManager.addError(fishAppletError);
        this.actor.remove_all_children();
        const errorIcon = ErrorIcon();
        this.actor.add_child(errorIcon);
        this.updateMessagePopup();
    }
    async checkIfFoolsDay() {
        var _a, _b;
        const prev = this.isFoolsDay;
        this.isFoolsDay = await isFoolsDay();
        if (prev !== this.isFoolsDay) {
            if (this.isFoolsDay) {
                (_a = this.animatedFish) === null || _a === void 0 ? void 0 : _a.enableIsFoolsDay();
            }
            else {
                (_b = this.animatedFish) === null || _b === void 0 ? void 0 : _b.disableIsFoolsDay();
            }
            this.updateMessagePopup();
        }
    }
    startPeriodicFoolsDayCheck() {
        this.stopPeriodicFoolsDayCheck();
        this.checkIfFoolsDay();
        this.foolsDayTimeoutId = Mainloop.timeout_add(FOOLS_DAY_CHECK_INTERVAL_IN_MS, () => {
            this.checkIfFoolsDay();
            return true;
        });
    }
    stopPeriodicFoolsDayCheck() {
        if (this.foolsDayTimeoutId > 0) {
            Mainloop.source_remove(this.foolsDayTimeoutId);
            this.foolsDayTimeoutId = 0;
        }
    }
    setThemeStyleClasses() {
        if (this.isDarkMode()) {
            this.actor.add_style_class_name("dark");
            if (this.messagePopup) {
                this.messagePopup.addStyleClassName("dark");
            }
        }
        else {
            this.actor.remove_style_class_name("dark");
            if (this.messagePopup) {
                this.messagePopup.removeStyleClassName("dark");
            }
        }
    }
    changeTheme() {
        this.setThemeStyleClasses();
    }
    isDarkMode() {
        return getThemeAppearance(DEFAULT_APPLET_CLASS_NAME) === "Dark" ? true : false;
    }
    getAppletMargin() {
        if (this.settingsObject.autoAnimationMargin) {
            return getMargin(DEFAULT_APPLET_CLASS_NAME);
        }
        return this.settingsObject.customAnimationMargin;
    }
}

;// ./src/FishApplet/index.ts


;// ./src/applet.ts



const applet_Gettext = imports.gettext;
const { GLib: applet_GLib } = imports.gi;
function main(metadata, orientation, panelHeight, instanceId) {
    applet_Gettext.bindtextdomain(UUID, applet_GLib.get_home_dir() + "/.local/share/locale");
    logger.setInstanceId(instanceId);
    return new FishApplet(metadata, orientation, panelHeight, instanceId);
}

fishApplet = __webpack_exports__;
/******/ })()
;